#include <jni.h>
#include <string.h>
#include <stdio.h>
#include <android/log.h>

#define DEBUG_TAG "NDK_NativeBasicsActivity"

#define NUM_RANGE_MIN 21
#define NUM_RANGE_MAX 84

void Java_com_androidbook_simplendk_NativeBasicsActivity_basicNativeCall
   (JNIEnv *env, jobject this)
{
	// tu można zrobić coś interesującego
	
	__android_log_print(ANDROID_LOG_VERBOSE, DEBUG_TAG, "Proste wywołanie");
}

jstring Java_com_androidbook_simplendk_NativeBasicsActivity_formattedAddition
    (JNIEnv *env, jobject this, jint number1, jint number2, jstring formatString)
{
	// pobranie łańcucha znaków C z obiektu String Javy 
	jboolean fCopy;
	const char * szFormat = (*env)->GetStringUTFChars(env, formatString, &fCopy);
    
	char * szResult;
	
	// dodanie dwóch liczb
	jlong nSum = number1+number2;
	
	// zapewnienie odpowiednio dużego miejsca w pamięci na łańcuch wynikowy
	szResult = malloc(sizeof(szFormat)+30);
	
	// wywołanie
	sprintf(szResult, szFormat, nSum);
	
	// pobranie obiektu String Javy
	jstring result = (*env)->NewStringUTF(env, szResult);
	
	// zwolnienie pamięci zawierającej łańcuch wynikowy
	free(szResult);
	(*env)->ReleaseStringUTFChars(env, formatString, szFormat);
	
	// zwrócenie obiektu String Javy
	return(result);
}

void Java_com_androidbook_simplendk_NativeBasicsActivity_throwsException
(JNIEnv * env, jobject this, jint number)
{
    if (number < NUM_RANGE_MIN || number > NUM_RANGE_MAX) {
		// zgłoszenie wyjątku
		jclass illegalArgumentException = 
            (*env)->FindClass(env, "java/lang/IllegalArgumentException");
		if (illegalArgumentException == NULL) {
			return;
		}
		(*env)->ThrowNew(env, illegalArgumentException, "Co za wyjątkowa wartość.");        
    } else {
        __android_log_print(ANDROID_LOG_VERBOSE, DEBUG_TAG, "Nic szczególnego...");
    }
}


void Java_com_androidbook_simplendk_NativeBasicsActivity_checksException
    (JNIEnv * env, jobject this, jint number)
{   
    jthrowable exception;
    jclass class = (*env)->GetObjectClass(env, this);    
    
    jmethodID fnJavaThrowsException =
        (*env)->GetMethodID(env, class, "javaThrowsException", "(I)V");
    
    if (fnJavaThrowsException != NULL) {
        (*env)->CallVoidMethod(env, this, fnJavaThrowsException, number);
        exception =	(*env)->ExceptionOccurred(env);
        if (exception) {
            (*env)->ExceptionDescribe(env);
            (*env)->ExceptionClear(env);
            __android_log_print(ANDROID_LOG_ERROR,
                DEBUG_TAG, "Wyjątek. Informacje znajdziesz w panelu LogCat.");
        }
    } else {
        __android_log_print(ANDROID_LOG_ERROR, DEBUG_TAG, "Nie znaleziono metody");
    }
}

